import { AdminService } from './admin.service';
import { UpdateVendorStatusDto, CreateProductDto, UpdateProductDto } from './dto/dto';
export declare class AdminController {
    private readonly adminService;
    constructor(adminService: AdminService);
    getDashboardStats(): Promise<{
        totals: {
            vendors: number;
            customers: number;
            products: number;
            orders: number;
            pendingVendors: number;
        };
        recentOrders: import("../../entities/order.entity").Order[];
        chartData: {
            orders: any[];
        };
    }>;
    getAllVendors(): Promise<import("../../entities/vendor.entity").Vendor[]>;
    getPendingVendors(): Promise<import("../../entities/vendor.entity").Vendor[]>;
    getVendorById(id: string): Promise<import("../../entities/vendor.entity").Vendor>;
    updateVendorStatus(id: string, updateVendorStatusDto: UpdateVendorStatusDto): Promise<import("../../entities/vendor.entity").Vendor>;
    approveVendor(id: string, notes?: string): Promise<import("../../entities/vendor.entity").Vendor>;
    rejectVendor(id: string, reason: string): Promise<import("../../entities/vendor.entity").Vendor>;
    getAllUsers(): Promise<import("../../entities/user.entity").User[]>;
    getUserById(id: string): Promise<import("../../entities/user.entity").User>;
    updateUserRole(id: string, role: string): Promise<import("../../entities/user.entity").User>;
    createProduct(createProductDto: CreateProductDto): Promise<import("../../entities/product.entity").Product[]>;
    updateProduct(id: string, updateProductDto: UpdateProductDto): Promise<import("../../entities/product.entity").Product>;
    deleteProduct(id: string): Promise<void>;
}
